; The CMD file.
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = some_name
;   command = the_command
;   time = time (optional)
;   buffer.time = time (optional)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas. Each of these
;   buttons or directions is referred to as a "symbol".
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /DB, a   ;hold down-back while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   greater-than (>) - means there must be no other keys pressed or released
;                      between the previous and the current symbol.
;          egs. command = a, >~a   ;press a and release it without having hit
;                                  ;or released any other keys in between
;   You can combine the symbols:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;
;   Note: Successive direction symbols are always expanded in a manner similar
;         to this example:
;           command = F, F
;         is expanded when MUGEN reads it, to become equivalent to:
;           command = F, >~F, >F
;
;   It is recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This makes the command easier
;   to do.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. The default
;   value for this is set in the [Defaults] section below. A typical
;   value is 15.
;
; - buffer.time (optional)
;   Time that the command will be buffered for. If the command is done
;   successfully, then it will be valid for this time. The simplest
;   case is to set this to 1. That means that the command is valid
;   only in the same tick it is performed. With a higher value, such
;   as 3 or 4, you can get a "looser" feel to the command. The result
;   is that combos can become easier to do because you can perform
;   the command early. Attacks just as you regain control (eg. from
;   getting up) also become easier to do. The side effect of this is
;   that the command is continuously asserted, so it will seem as if
;   you had performed the move rapidly in succession during the valid
;   time. To understand this, try setting buffer.time to 30 and hit
;   a fast attack, such as KFM's light punch.
;   The default value for this is set in the [Defaults] section below. 
;   This parameter does not affect hold-only commands (eg. /F). It
;   will be assumed to be 1 for those commands.
;
; If you have two or more commands with the same name, all of them will
; work. You can use it to allow multiple motions for the same move.
;
; Some common commands examples are given below.
;
; [Command] ;Quarter circle forward + x
; name = "QCF_x"
; command = ~D, DF, F, x
;
; [Command] ;Half circle back + a
; name = "HCB_a"
; command = ~F, DF, D, DB, B, a
;
; [Command] ;Two quarter circles forward + y
; name = "2QCF_y"
; command = ~D, DF, F, D, DF, F, y
;
; [Command] ;Tap b rapidly
; name = "5b"
; command = b, b, b, b, b
; time = 30
;
; [Command] ;Charge back, then forward + z
; name = "charge_B_F_z"
; command = ~60$B, F, z
; time = 10
;
; [Command] ;Charge down, then up + c
; name = "charge_D_U_c"
; command = ~60$D, U, c
; time = 10


;-| Button Remapping |-----------------------------------------------------
; This section lets you remap the player's buttons (to easily change the
; button configuration). The format is:
;   old_button = new_button
; If new_button is left blank, the button cannot be pressed.
[Remap]
x = x
y = y
z = z
a = a
b = b
c = c
s = s

;-| Default Values |-------------------------------------------------------
[Defaults]
; Default value for the "time" parameter of a Command. Minimum 1.
command.time = 15

; Default value for the "buffer.time" parameter of a Command. Minimum 1,
; maximum 30.
command.buffer.time = 1




;-| Super Motions |--------------------------------------------------------
;The following two have the same name, but different motion.
;Either one will be detected by a "command = TripleKFPalm" trigger.
;Time is set to 20 (instead of default of 15) to make the move
;easier to do.

[Command]
name = "supersoulstrike"
command = D, D, a+x

[Command]
name = "SafetyCoat"
command = ~D, DF, F, D, DF, F, x
time = 30

[Command]
name = "SafetyCoat"   ;Same name as above
command = ~D, DF, F, D, DF, F, y
time = 30

[Command]
name = "VertWall"
command = D, D, b+y

;[Command]
;name = "SmashKFUpper"
;command = ~D, DB, B, D, DB, B, x;~F, D, DF, F, D, DF, x
;time = 20

;[Command]
;name = "SmashKFUpper"   ;Same name as above
;command = ~D, DB, B, D, DB, B, y;~F, D, DF, F, D, DF, y
;time = 20

;-| Special Motions |------------------------------------------------------
[Command]
name = "FF_a"
command = F, F, a
time = 15

[Command]
name = "FF_b"
command = F, F, b
time = 15

[Command]
name = "FF_x"
command = F, F, x
time = 15

[Command]
name = "FF_y"
command = F, F, y
time = 15

[Command]
name = "DD_z"
command = D, D, z
time = 20

;-| Magic Attacks |--------------------------------------------------------
[Command]
name = "soulstrike"
command = D, D, a
time = 20

[Command]
name = "soulstrike"
command = D, D, x
time = 20

[Command]
name = "firewall"
command = D, D, b
time = 20

[Command]
name = "firewall"
command = D, D, y
time = 20

[Command]
name = "energycoat"
command = F, F, b
time = 20

[Command]
name = "energycoat"
command = F, F, y
time = 20

[Command]
name = "thunderbolt"
command = D, F, a
time = 20

[Command]
name = "thunderbolt"
command = D, F, x
time = 20

[Command]
name = "firebolt"
command = D, D, a
time = 20

[Command]
name = "firebolt"
command = D, D, x
time = 20

[Command]
name = "coldbolt"
command = D, D, b
time = 20

[Command]
name = "coldbolt"
command = D, D, y
time = 20

[Command]
name = "fireball"
command = B, F, b
time = 20

[Command]
name = "fireball"
command = B, F, y
time = 20

[Command]
name = "frostdriver"
command = B, F, a
time = 20

[Command]
name = "frostdriver"
command = B, F, x
time = 20

[Command]
name = "stonecurse"
command = F, F, a
time = 20

[Command]
name = "stonecurse"
command = F, F, x
time = 20

[Command]
name = "thunderstorm"
command = D, F, b
time = 20

[Command]
name = "thunderstorm"
command = D, F, y
time = 20

[Command]
name = "safetywall"
command = D, U, b
time = 20

[Command]
name = "safetywall"
command = D, U, y
time = 20

;-| Double Tap |-----------------------------------------------------------
[Command]
name = "FF"     ;Required (do not remove)
command = F, F
time = 10

[Command]
name = "BB"     ;Required (do not remove)
command = B, B
time = 10

;-| 2/3 Button Combination |-----------------------------------------------

[Command]
name = "recovery";Required (do not remove)
command = x
time = 1

[Command]
name = "recovery";Required (do not remove)
command = y
time = 1

[Command]
name = "recovery";Required (do not remove)
command = a
time = 1

[Command]
name = "recovery";Required (do not remove)
command = b
time = 1

;-| Dir + Button |---------------------------------------------------------

[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1

;-| Single Button |---------------------------------------------------------
[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "start"
command = s
time = 1

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "holdDF"
command = /$DF
time = 1

[Command]
name = "holdfwd";Required (do not remove)
command = /$F
time = 1

[Command]
name = "holdback";Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdup" ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holddown";Required (do not remove)
command = /$D
time = 1

[Command]
name = "holdz"
command = /$z
time = 1

;-| Press Dir |-------------------------------------------------------------
[Command]
name = "jump"
command = U
time = 1

[Command]
name = "jump"
command = U+F
time = 1

[Command]
name = "jump"
command = U+B
time = 1

[Command]
name = "up"
command = U
time = 1

[Command]
name = "down"
command = D
time = 1

;---------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1, Label]           ;Change Label to any name you want to use to
;                               ;identify the state with.
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1 = command = command_name
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; Note: The order of state entry is important.
;   State entry with a certain command must come before another state
;   entry with a command that is the subset of the first.
;   For example, command "fwd_a" must be listed before "a", and
;   "fwd_ab" should come before both of the others.
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in.


; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]

;===========================================================================

;Super Soul Strike (Hyper)
[State -1, Super Soul Strike]
type = ChangeState
value = 3000
triggerall = var(1) != 1 && command = "supersoulstrike" && var(8) = 0 && power >= 7000
triggerall = var(19) = 3 || var(19) = 0
trigger1 = statetype = A && (ctrl)
trigger2 = stateno = 1350 ;Air blocking
trigger3 = stateno = 100 || stateno = 105 ;Dash/Airdash
trigger4 = (movecontact) && (stateno = 600 || stateno = 620 || stateno = 630)
trigger5 = stateno = 2025 && time > 8

;Safety Coat (Hyper)
[State -1, Safety Coat]
type = ChangeState
value = 3100
triggerall = var(1) != 1 && command = "SafetyCoat" && power >= 3500 && stateno = 2001
triggerall = var(19) = 1 || var(19) = 3
trigger1 = numhelper(2124) > 0 && (pos x - (helper(2124), pos x) = [-100,100])
trigger1 = (helper(2124), anim) = [2124, 2127]

;Vertical Firewall (Hyper)
[State -1, Vert Wall]
type = ChangeState
value = 3200
triggerall = var(1) != 1 && command = "VertWall" && power >= 2000
triggerall = var(19) > 1
trigger1 = statetype != A && (ctrl)

;===========================================================================
;This is not a move, but it sets up var(1) to be 1 if conditions are right
;for a combo into a special move (used below).
;Since a lot of special moves rely on the same conditions, this reduces
;redundant logic.
;[State -1, Combo condition Reset]
;type = VarSet
;trigger1 = 1
;var(1) = 0

;[State -1, Combo condition Check]
;type = VarSet
;trigger1 = statetype != A
;trigger1 = ctrl
;trigger2 = (stateno = [200,299]) || (stateno = [400,499])
;trigger2 = stateno != 440 ;Except for sweep kick
;trigger2 = movecontact
;var(1) = 1

;---------------------------------------------------------------------------
;Damascus Dagger
[State -1, Damascus Dagger]
type = ChangeState
value = 1010
triggerall = (command = "FF_a" || command = "FF_x") && var(1) != 1 && var(4) < 4
trigger1 = statetype = S && (ctrl)
trigger2 = stateno = 200 && time > 4
trigger3 = (movecontact) && (stateno = [210,230])
trigger4 = (movecontact) && (stateno = [400,430])
trigger5 = stateno = 100 && time < 6 && pos y > -15 && vel y <= 0
trigger6 = (movecontact) && (stateno = 1020)

;Lightening Lick
[State -1, Lightening Kick]
type = ChangeState
value = 1040
triggerall = (command = "FF_b" || command = "FF_y") && var(1) != 1 && var(4) < 4
trigger1 = statetype = S && (ctrl)
trigger2 = stateno = 200 && time > 4
trigger3 = (movecontact) && (stateno = [210,230])
trigger4 = (movecontact) && (stateno = [400,430])
trigger5 = stateno = 100 && time < 6 && pos y > -15 && vel y <= 0
trigger6 = (movecontact) && (stateno = 1020)

;===========================================================================
;---------------------------------------------------------------------------
;Run Fwd
[State -1, Run Fwd]
type = ChangeState
value = 100
triggerall = command = "FF" && var(1) != 1
trigger1 = statetype = S && (ctrl)

;Run Back
[State -1, Run Back]
type = ChangeState
value = 105
triggerall = command = "BB" && var(1) != 1
trigger1 = statetype = S && (ctrl)

;---------------------------------------------------------------------------
;Air Dash Fwrd
[State -1, AirDashFwd]
type = ChangeState
value = 102
triggerall = command = "FF" && var(1) != 1
triggerall = stateno != 100 && stateno != 105
trigger1 = statetype = A && (ctrl) && power >= 5
trigger2 = stateno = 2025 && time > 8

;Air Dash Bkwd
[State -1, AirDashBkwd]
type = ChangeState
value = 107
triggerall = command = "BB" && var(1) != 1
triggerall = stateno != 100 && stateno != 105
trigger1 = statetype = A && (ctrl) && power >= 5
trigger2 = stateno = 2025 && time > 8


;===========================================================================
; NON-CASTING MAGIC
; These don't have to be cast but they do have cast delays

;---------------------------------------------------------------------------
;Soul Strike (ground)
[State -1, Soul Strike Ground]
type = ChangeState
value = 2020
triggerall = var(1) != 1 && command = "soulstrike" && var(8) = 0 && power >= 300
triggerall = var(19) != 1
trigger1 = statetype != A && (ctrl)
trigger2 = (movecontact) && (stateno = [200,230])
trigger3 = (movecontact) && (stateno = [400,430])
trigger4 = (movecontact) && (stateno = 1020)

;---------------------------------------------------------------------------
;Soul Strike (Air)
[State -1, Soul Strike Air]
type = ChangeState
value = 2025
triggerall = var(1) != 1 && command = "soulstrike" && var(8) = 0 && power >= 300
triggerall = var(19) != 1
trigger1 = statetype = A && (ctrl)
trigger2 = stateno = 1350 ;Air blocking
trigger3 = stateno = 100 || stateno = 105 ;Dash/Airdash
trigger4 = (movecontact) && (stateno = 600 || stateno = 620 || stateno = 630)
trigger5 = stateno = 2025 && time > 8

;---------------------------------------------------------------------------
;Fireblast
[State -1, Fireblast]
type = ChangeState
value = 2160
triggerall = var(1) != 1 && command = "z" && power >= 300 ;&& var(8) = 0
triggerall = var(19) = 2 || (var(19) = 3 && command = "holdfwd")
triggerall = statetype != A && (ctrl)
trigger1 = numhelper(2155) > 0 && pos x - (helper(2155), pos x) = [-90, 90]
trigger2 = numhelper(2156) > 0 && pos x - (helper(2156), pos x) = [-70, 70]
trigger3 = numhelper(2157) > 0 && pos x - (helper(2157), pos x) = [-50, 50]

;---------------------------------------------------------------------------
;Energy Field
[State -1, Energy Field]
type = ChangeState
value = 1500
triggerall = var(1) != 1 && command = "z" && command != "holddown" && var(8) = 0 && power >= 150
triggerall = pos y = 0 && (var(19) = 0 || var(19) = 3)
trigger1 = statetype != A && (ctrl)
trigger2 = statetype != A && movetype = H && time < 5 && (var(9))

;---------------------------------------------------------------------------
;Firewall
[State -1, Firewall]
type = ChangeState
value = 2150
triggerall = var(1) != 1 && command = "firewall" && var(8) = 0 && power >= 450
triggerall = var(19) > 1 && numhelper(2155) = 0
trigger1 = statetype != A && (ctrl)
trigger2 = (movecontact) && (stateno = [200,230])
trigger3 = (movecontact) && (stateno = [400,430])
trigger4 = (movecontact) && (stateno = 1020)

;===========================================================================





;===========================================================================
; CASTING MAGIC
; The thing these all have in common is that they must be done from state
;    2001 (or the casting state)

;---------------------------------------------------------------------------
;Energy Coat
[State -1, Energy Coat]
type = ChangeState
value = 2030
triggerall = var(1) != 1 && command = "energycoat" && power >= 300 && stateno = 2001
trigger1 = var(19) = 0
trigger2 = var(19) = 3

;---------------------------------------------------------------------------
;Napalm Beat
[State -1, Napalm Beat]
type = ChangeState
value = 2010
triggerall = var(1) != 1 && command = "c" && power >= 50
triggerall = var(19) = 0 || var(19) = 3
trigger1 = stateno = 2001

;---------------------------------------------------------------------------
;Thunder Bolt
[State -1, Thunder Bolt]
type = ChangeState
value = 2040
triggerall = var(1) != 1 && command = "thunderbolt" && stateno = 2001
trigger1 = var(19) = 0 && power >= 260
trigger2 = var(19) = 1 && power >= 260
trigger3 = var(19) = 3 && power >= 300

;---------------------------------------------------------------------------
;Fire Bolt
[State -1, Fire Bolt]
type = ChangeState
value = 2050
triggerall = var(1) != 1 && command = "firebolt" && stateno = 2001
trigger1 = var(19) = 1 && power >= 130
trigger2 = var(19) = 2 && power >= 120
trigger3 = var(19) = 3 && power >= 140
;trigger4 = var(19) = 0 && power >= 100

;---------------------------------------------------------------------------
;Cold Bolt
[State -1, Cold Bolt]
type = ChangeState
value = 2060
triggerall = var(1) != 1 && command = "coldbolt" && stateno = 2001
trigger1 = var(19) = 1 && power >= 190
trigger2 = var(19) = 2 && power >= 150
trigger3 = var(19) = 3 && power >= 280
;trigger4 = var(19) = 0 && power >= 100

;---------------------------------------------------------------------------
;Fire Ball
[State -1, Fire Ball]
type = ChangeState
value = 2070
triggerall = var(1) != 1 && command = "fireball" && stateno = 2001 && power >= 350
trigger1 = var(19) != 1

;---------------------------------------------------------------------------
;Frost Driver
[State -1, Frost Driver]
type = ChangeState
value = 2080
triggerall = var(1) != 1 && command = "frostdriver" && stateno = 2001 && power >= 100
trigger1 = var(19) = 0
trigger2 = var(19) = 3

;---------------------------------------------------------------------------
;Stone Curse
[State -1, Stone Curse]
type = ChangeState
value = 2100
triggerall = var(1) != 1 && command = "stonecurse" && stateno = 2001 && power >= 150
trigger1 = var(19) = 1
trigger2 = var(19) = 3

;---------------------------------------------------------------------------
;Thunder Storm
[State -1, Thunder Storm]
type = ChangeState
value = 2110
triggerall = var(1) != 1 && command = "thunderstorm" && stateno = 2001
trigger1 = var(19) = 1 && power >= 1000
trigger2 = var(19) = 2 && power >= 600
trigger3 = var(19) = 3 && power >= 1000

;---------------------------------------------------------------------------
;Safety Wall
[State -1, Safety Wall]
type = ChangeState
value = 2120
triggerall = var(1) != 1 && command = "safetywall" && stateno = 2001 && power >= 500 && numhelper(2124) = 0 && var(22) > 0
trigger1 = var(19) = 1
trigger2 = var(19) = 3

;---------------------------------------------------------------------------
;Dispell Safety Wall
[State -1, Dispell Safety Wall]
type = ChangeState
value = 2140
triggerall = var(1) != 1 && power >= 10 && numhelper(2124) > 0 && command = "z" && (helper(2124), anim) != [2128, 2129]
trigger1 = var(19) = 1 && command != "holddown" && statetype != A && (ctrl)
trigger2 = var(19) = 3 && command = "holdback" && statetype != A && (ctrl)


;===========================================================================
; Special attacks

;---------------------------------------------------------------------------
;Razor Cape
[State -1, Razor Cape]
type = ChangeState
value = 1000
triggerall = command = "holdDF" && (command = "b" || command = "y")
triggerall = var(1) != 1 && var(4) < 4
trigger1 = statetype != A && (ctrl)
trigger2 = stateno = 200 && time > 4
trigger3 = (movecontact) && (stateno = [210,230])
trigger4 = (movecontact) && (stateno = [400,430])
trigger5 = (movecontact) && (stateno = 1020)

;---------------------------------------------------------------------------
;Napalm Field
[State -1, Napalm Field]
type = ChangeState
value = 1020
triggerall = (command = "holdfwd" || command = "holdback") && (command = "b" || command = "y")
triggerall = var(1) != 1 && var(4) < 4
trigger1 = statetype != A && (ctrl)
trigger2 = stateno = 200 && time > 4
trigger3 = (movecontact) && (stateno = [210,230])
trigger4 = (movecontact) && (stateno = [400,430])
trigger5 = (movecontact) && (stateno = 1020)

;===========================================================================


;---------------------------------------------------------------------------
;Stand Jab
[State -1, Stand Jab]
type = ChangeState
value = 200
triggerall = command = "x" && command != "holddown" && var(1) != 1
trigger1 = statetype != A && (ctrl)
trigger2 = stateno = 200 && time > 4
trigger3 = (movecontact) && (stateno = [210,230])
trigger4 = (movecontact) && (stateno = [400,430])
trigger5 = (movecontact) && (stateno = 1020)

;---------------------------------------------------------------------------
;Stand Punch
[State -1, Stand Punch]
type = ChangeState
value = 210
triggerall = command = "y" && command != "holddown" && var(4) < 4 && var(1) != 1
trigger1 = statetype != A && (ctrl)
trigger2 = (movecontact) && (stateno = [200,230])
trigger3 = (movecontact) && (stateno = [400,430])
trigger4 = (movecontact) && (stateno = 1020)

;---------------------------------------------------------------------------
;Stand Slash
[State -1, Stand Slash]
type = ChangeState
value = 220
triggerall = command = "a" && command != "holddown" && var(1) != 1
trigger1 = statetype != A && (ctrl)
trigger2 = (movecontact) && (stateno = [200,230])
trigger3 = (movecontact) && (stateno = [400,430])
trigger4 = (movecontact) && (stateno = 1020)

;---------------------------------------------------------------------------
;Standing Stab
[State -1, Standing Stab]
type = ChangeState
value = 230
triggerall = command = "b" && command != "holddown" && var(4) < 4 && var(1) != 1
trigger1 = statetype != A && (ctrl)
trigger2 = (movecontact) && (stateno = [200,230])
trigger3 = (movecontact) && (stateno = [400,430])
trigger4 = (movecontact) && (stateno = 1020)

;---------------------------------------------------------------------------
;Casting
[State -1, Casting]
type = ChangeState
value = 2000
triggerall = var(1) != 1 && command = "c"
trigger1 = statetype != A && (ctrl)
trigger2 = (movecontact) && (stateno = [200,230])
trigger3 = (movecontact) && (stateno = [400,430])
trigger4 = (movecontact) && (stateno = 1020)
trigger5 = (stateno = 2002)

;---------------------------------------------------------------------------
;Taunt
[State -1, Taunt]
type = ChangeState
value = 195
triggerall = stateno = 0 && ctrl
trigger1 = command = "start"

;---------------------------------------------------------------------------
;SP Recovery
[State -1, SP Recovery]
type = ChangeState
value = 300
triggerall = var(1) != 1 && command = "holdz" && command = "holddown"
trigger1 = statetype != A && (ctrl)

;---------------------------------------------------------------------------
;Crouching Jab
[State -1, Crouching Jab]
type = ChangeState
value = 400
triggerall = command = "x" && command = "holddown" && var(1) != 1
trigger1 = statetype != A && (ctrl)
trigger2 = (movecontact) && (stateno = [200,230])
trigger3 = (movecontact) && (stateno = [400,430])
trigger4 = (stateno = 400) && (time >= 10)
trigger5 = (movecontact) && (stateno = 1020)

;---------------------------------------------------------------------------
;Crouching Flick Energy
[State -1, Crouching Flick Energy]
type = ChangeState
value = 410
triggerall = command = "y" && command = "holddown" && var(4) < 4 && var(1) != 1
trigger1 = statetype != A && (ctrl)
trigger2 = (movecontact) && (stateno = [200,230])
trigger3 = (movecontact) && (stateno = [400,430])
trigger4 = (movecontact) && (stateno = 1020)

;---------------------------------------------------------------------------
;Crouching Stab
[State -1, Crouching Stab]
type = ChangeState
value = 420
triggerall = command = "a" && command = "holddown" && var(1) != 1
trigger1 = statetype != A && (ctrl)
trigger2 = (movecontact) && (stateno = [200,230])
trigger3 = (movecontact) && (stateno = [400,430])
trigger4 = (movecontact) && (stateno = 1020)

;---------------------------------------------------------------------------
;Crouching Upward Stab
[State -1, Crouching Upward Stab]
type = ChangeState
value = 430
triggerall = command = "b" && command = "holddown" && var(4) < 4 && var(1) != 1
trigger1 = statetype != A && (ctrl)
trigger2 = (movecontact) && (stateno = [200,230])
trigger3 = (movecontact) && (stateno = [400,430])
trigger4 = (movecontact) && (stateno = 1020)

;---------------------------------------------------------------------------
;Jump Jab
[State -1, Jump Jab]
type = ChangeState
value = 600
triggerall = command = "x" && var(1) != 1
trigger1 = statetype = A && (ctrl)
trigger2 = stateno = 1350 ;Air blocking
trigger3 = stateno = 100 || stateno = 105 ;Dash/Airdash
trigger4 = (movecontact) && (stateno = 600 || stateno = 620 || stateno = 630)
trigger5 = stateno = 2025 && time > 8

;---------------------------------------------------------------------------
;Lightening Hammer Strike
[State -1, Lightening Hammer Strike]
type = ChangeState
value = 610
triggerall = command = "y" && var(4) < 4 && var(1) != 1
trigger1 = statetype = A && (ctrl)
trigger2 = stateno = 1350 ;Air blocking
trigger3 = stateno = 100 || stateno = 105 ;Dash/Airdash
trigger4 = (movecontact) && (stateno = 600 || stateno = 620 || stateno = 630)
trigger5 = stateno = 2025 && time > 8

;---------------------------------------------------------------------------
;Jump Slash
[State -1, Jump Slash]
type = ChangeState
value = 620
triggerall = command = "a" && var(1) != 1
trigger1 = statetype = A && (ctrl)
trigger2 = stateno = 1350 ;Air blocking
trigger3 = stateno = 100 || stateno = 105 ;Dash/Airdash
trigger4 = (movecontact) && (stateno = 600 || stateno = 620 || stateno = 630)
trigger5 = stateno = 2025 && time > 8

;---------------------------------------------------------------------------
;Jump Spinning Dagger
[State -1, Spinning Dagger]
type = ChangeState
value = 630
triggerall = command = "b" && var(4) < 4 && var(1) != 1
trigger1 = statetype = A && (ctrl)
trigger2 = stateno = 1350 ;Air blocking
trigger3 = stateno = 100 || stateno = 105 ;Dash/Airdash
trigger4 = (movecontact) && (stateno = 600 || stateno = 620 || stateno = 630)
trigger5 = stateno = 2025 && time > 8

;---------------------------------------------------------------------------
;Jump
[State -1, Jump From Attack]
type = changestate
value = 40
triggerall = command = "jump" && var(1) != 1
trigger1 = (movecontact) && (stateno = [200,230])
trigger2 = (movecontact) && (stateno = [400,430])
trigger3 = (movecontact) && (stateno = 1020)

;Air Jump
[State -1, Air Jump From Attack]
type = changestate
value = 45
triggerall = command = "jump" && var(3) = 0 && var(1) != 1
trigger1 = (movecontact) && (stateno = 600 || stateno = 620 || stateno = 630)
trigger2 = stateno = 2025 && time > 8











;===================================
[State -1]
type = varset
trigger1 = 0
v = 0
value = 0












;-----------------------------------------------------------------------------
;AI STUFF
;-----------------------------------------------------------------------------

[State -1]
Type=VarSet
Trigger1=1
var(21)=(AILevel=1)*3+(AILevel=2)*7+(AILevel=3)*16+(AILevel=4)*30+(AILevel=5)*58+(AILevel=6)*90+ (AILevel=7)*200+(AILevel=8)*1000

[state -1, Deactivate AI]
type = varset
trigger1 = var(1); && roundstate != 2
var(1) = 0

[State -1, Activate AI]
type = VarSet
triggerall = Roundstate = 2 && var(1) < 1
Trigger1 = AILevel > 0 && random < var(21)
v = 1 ;You can change this to any number provided that it doesn't collide with other variables.
value = 1

;---------------------------------------------------------------------------
;Jump
[State -1, AIJump From Attack]
type = changestate
value = 40
triggerall = var(1) = 1
triggerall = (movecontact) && ((stateno = [200,230]) || (stateno = [400,430]) || (stateno = 1020))
trigger1 = p2bodydist y < -60 && random < 500
trigger2 = random < 50
trigger3 = p2movetype = A && random < 750


;Air Jump
[State -1, AIAir Jump From Attack]
type = changestate
value = 45
triggerall = var(3) = 0 && var(1) = 1
triggerall = (movecontact) && (stateno = 600 || stateno = 620 || stateno = 630)
trigger1 = p2bodydist y < -60 && random < 500
trigger2 = random < 50
trigger3 = p2movetype = A && random < 750
trigger4 = stateno = 2025 && time > 8 && random < 50
trigger5 = stateno = 1020

[State -1,AIGroundrecover]
type = ChangeState
value = 5201
triggerall = var(1) = 1  && canrecover && statetype = A && movetype = H
trigger1 = Vel Y > 0 && Pos Y >= 0 && random <= 50

[State -1,AIAirrecover]
type = ChangeState
value = 5210
triggerall = var(1) = 1  && canrecover && statetype = A && movetype = H
trigger1 = Pos Y < 0 && random <= 50

; AI Standing Guard
[State -1]
type = ChangeState
triggerall = var(1) = 1 ;AI trigger used
triggerall = Statetype != A ;Player is not in the air
triggerall = P2statetype != C ;Player is not crouching
triggerall = Statetype = S ;Player is currently standing
triggerall = P2Movetype = A ;Opponent is attacking
triggerall = Pos Y != [-1,-1999]
triggerall = ctrl = 1
trigger1 = random <= 800 ;triggers at 80% probability
value = 130 ;Default standing guard state

; AI Stand to Crouch Guard Transition
[State -1]
type = ChangeState
triggerall = var(1) = 1
triggerall = StateType != A
triggerall = P2statetype = C
triggerall = P2Movetype = A
triggerall = Pos Y != [-1,-1999]
trigger1 = stateno = 150
trigger1 = 1
value = 152

; AI Crouching Guard
[State -1]
type = ChangeState
triggerall = var(1) = 1
triggerall = StateType != A
triggerall = P2statetype = C
triggerall = P2Movetype = A
triggerall = Pos Y != [-1,-1999]
triggerall = ctrl = 1
trigger1 = random <= 800
value = 131

; AI Crouch to Stand Guard Transition
[State -1]
type = ChangeState
triggerall = var(1) = 1
triggerall = Statetype != A
triggerall = P2statetype != C
triggerall = P2Movetype = A
trigger1 = 1
trigger1 = stateno = 152
value = 150

; AI Aerial Guard
[State -1]
type = ChangeState
triggerall = var(1) = 1
triggerall = Statetype = A
triggerall = P2Movetype = A
triggerall = ctrl = 1
trigger1 = random <= 800
value = 132

[state -1, AI]
type = changestate
triggerall = var(1) = 1 && random < 250
trigger1 = stateno = 11
trigger2 = stateno = 0
value = 20

[state -1, AI]
type = varset
triggerall = var(1) = 1 && ((stateno = 20) || (stateno = 40) || (stateno = 45))
trigger1 = p2movetype != A
var(2) = 1

[state -1, AI]
type = varset
triggerall = var(1) = 1 && ((stateno = 20) || (stateno = 40) || (stateno = 45))
trigger1 = p2movetype = A
var(2) = -1

;---------------------------------------------------------------------------
;Super Soul Strike (Hyper)
[State -1, AI Super Soul Strike]
type = ChangeState
value = 3000
triggerall = var(1) = 1 && random < 1000 && var(8) = 0 && power >= 7000
triggerall = p2movetype != I && moveguarded = 0
triggerall = var(19) = 0 || var(19) = 3
trigger1 = statetype = A && (ctrl)
trigger2 = stateno = 1350 ;Air blocking
trigger3 = stateno = 100 || stateno = 105 ;Dash/Airdash
trigger4 = (movecontact) && (stateno = 600 || stateno = 620 || stateno = 630)
trigger5 = stateno = 2025 && time > 8

;Safety Coat (Hyper)
[State -1, AI Safety Coat]
type = ChangeState
value = 3100
triggerall = var(1) = 1 && random < 1000 && power >= 3500 && stateno = 2001
triggerall = var(19) = 1 || var(19) = 3
trigger1 = numhelper(2124) > 0 && (pos x - (helper(2124), pos x) = [-100,100])
trigger1 = (helper(2124), anim) = [2124, 2127]

;Vertical Firewall (Hyper)
[State -1, AI Vert Wall]
type = ChangeState
value = 3200
triggerall = var(1) = 1 && random < 100 && power >= 2000
triggerall = var(19) > 1 && numhelper(2155) > 0
trigger1 = statetype != A && (ctrl)

;---------------------------------------------------------------------------
;Energy Coat
[State -1, AI Energy Coat]
type = ChangeState
value = 2030
triggerall = var(1) = 1 && power >= 300 && var(9) < 60
triggerall = var(19) = 0 || var(19) = 3
trigger1 = stateno = 2001 && p2movetype = H && random < 550

;Napalm Beat
[State -1, AI Napalm Beat]
type = ChangeState
value = 2010
triggerall = var(1) = 1 && random < 250 && power >= 50
triggerall = var(19) = 0 || var(19) = 3
trigger1 = stateno = 2001

;---------------------------------------------------------------------------
;Casting
[State -1, AI Casting]
type = ChangeState
value = 2000
triggerall = var(1) = 1 && power > 150
trigger1 = statetype != A && (ctrl) && p2bodydist x > 150 && random < 350
trigger2 = (movecontact) && (stateno = [200,230]) && random < 100
trigger3 = (movecontact) && (stateno = [400,430]) && random < 100
trigger4 = statetype != A && (ctrl) && p2bodydist x < 150 && (movecontact) && random < 250
trigger5 = statetype != A && (ctrl) && p2movetype = H && random < 450 && var(9) < 60

;---------------------------------------------------------------------------
;Run Fwd
[State -1, AI Run Fwd]
type = ChangeState
value = 100
triggerall = random < 500 && var(1) = 1
trigger1 = statetype = S && (ctrl) && p2movetype != A && p2bodydist x >= 200

;Run Back
[State -1, AI Run Back]
type = ChangeState
value = 105
triggerall = random < 500 && var(1) = 1
trigger1 = statetype = S && (ctrl) && p2movetype = A && p2bodydist x < 200

;---------------------------------------------------------------------------
;Air Dash Fwrd
[State -1, AI AirDashFwd]
type = ChangeState
value = 102
triggerall = random < 500 && var(1) = 1 && power >= 20 && p2movetype != A && p2bodydist x >= 200
triggerall = stateno != 100 && stateno != 105
trigger1 = statetype = S && (ctrl)
trigger2 = stateno = 2025 && time > 8

;Air Dash Bkwd
[State -1, AI AirDashBkwd]
type = ChangeState
value = 107
triggerall = random < 500 && var(1) = 1 && power >= 20 && p2movetype = A && p2bodydist x < 200
triggerall = stateno != 100 && stateno != 105
trigger1 = statetype = S && (ctrl)
trigger2 = stateno = 2025 && time > 8

;---------------------------------------------------------------------------
;Kung Fu Throw
;
;[State -1, Kung Fu Throw]
;type = ChangeState
;value = 800
;triggerall = command = "y"
;triggerall = statetype = S
;triggerall = ctrl
;triggerall = stateno != 100
;trigger1 = command = "holdfwd"
;trigger1 = p2bodydist X < 3
;trigger1 = (p2statetype = S) || (p2statetype = C)
;trigger1 = p2movetype != H
;trigger2 = command = "holdback"
;trigger2 = p2bodydist X < 5
;trigger2 = (p2statetype = S) || (p2statetype = C)
;trigger2 = p2movetype != H

;Energy Field
[State -1, AI Energy Field]
type = ChangeState
value = 1500
triggerall = var(1) = 1 && var(8) = 0 && power >= 150 && p2bodydist x < 100 && p2bodydist y > -100
triggerall = pos y = 0
triggerall = var(19) = 0 || var(19) = 3
trigger1 = statetype != A && (ctrl)
trigger2 = statetype != A && movetype = H && time < 5 && (var(9)) && random < 200

;---------------------------------------------------------------------------
;Thunderstorm
[State -1, AI Thunderstorm]
type = ChangeState
value = 2110
triggerall = var(1) = 1 && stateno = 2001
triggerall = (p2bodydist x > 200 && p2movetype = H && random < 50) || (numhelper(2124) > 0 && (pos x - (helper(2124), pos x) = [-100,100]))
trigger1 = (var(19) = 1 || var(19) = 3) && power >= 1000
trigger2 = var(19) = 2 && power >= 600

;---------------------------------------------------------------------------
;Safety Wall
[State -1, AI Safety Wall]
type = ChangeState
value = 2120
triggerall = var(1) = 1 && stateno = 2001 && random < var(22) * 50 && numhelper(2124) = 0
trigger1 = (var(19) = 1 || var(19) = 3) && power >= 500

;---------------------------------------------------------------------------
;Dispell Safety Wall
[State -1, AI Dispell Safety Wall]
type = ChangeState
value = 2140
triggerall = var(1) = 1 && statetype != A && (ctrl) && numhelper(2124) > 0 && var(22) > 1
triggerall = (var(19) = 1 || var(19) = 3) && power >= 10 && random < 500 && p2movetype != A
trigger1 = pos x > (helper(2124), pos x) + 400
trigger2 = pos x < (helper(2124), pos x) - 400

;---------------------------------------------------------------------------
;Firewall
[State -1, AI Firewall]
type = ChangeState
value = 2150
triggerall = var(1) = 1 && random < 500 && var(8) = 0 && power >= 450
triggerall = var(19) > 1 && numhelper(2155) = 0
trigger1 = statetype != A && (ctrl)
trigger2 = (movecontact) && (stateno = [200,230])
trigger3 = (movecontact) && (stateno = [400,430])
trigger4 = (movecontact) && (stateno = 1020)

;---------------------------------------------------------------------------
;Fireblast
[State -1, AI Fireblast]
type = ChangeState
value = 2160
triggerall = var(1) = 1 && random < 500 && power >= 300 ;&& var(8) = 0
triggerall = statetype != A && (ctrl) && var(19) > 1
triggerall = (enemynear, pos y > -30) && p2bodydist x < 180
trigger1 = numhelper(2155) > 0 && pos x - (helper(2155), pos x) = [-90, 90]
trigger2 = numhelper(2156) > 0 && pos x - (helper(2156), pos x) = [-70, 70]
trigger3 = numhelper(2157) > 0 && pos x - (helper(2157), pos x) = [-50, 50]

;---------------------------------------------------------------------------
;Soul Strike (ground)
[State -1, AI Soul Strike Ground]
type = ChangeState
value = 2020
triggerall = var(1) = 1 && random < 500 && var(8) = 0 && p2bodydist x > 200 && power >= 300
triggerall = var(19) != 1
trigger1 = statetype != A && (ctrl)
trigger2 = (movecontact) && (stateno = [200,230])
trigger3 = (movecontact) && (stateno = [400,430])

;---------------------------------------------------------------------------
;Soul Strike (Air)
[State -1, AI Soul Strike Air]
type = ChangeState
value = 2025
triggerall = var(1) = 1 && random < 500 && var(8) = 0 && power >= 300
triggerall = var(19) != 1
trigger1 = statetype = A && (ctrl)
trigger2 = stateno = 1350 ;Air blocking
trigger3 = stateno = 100 || stateno = 105 ;Dash/Airdash
trigger4 = (movecontact) && (stateno = 600 || stateno = 620 || stateno = 630)
trigger5 = stateno = 2025 && time > 8

;---------------------------------------------------------------------------
;Thunder Bolt
[State -1, AI Thunder Bolt]
type = ChangeState
value = 2040
triggerall = var(1) = 1 && power >= 260
triggerall = (p2dist x = [25, 400]) && stateno = 2001
triggerall = var(19) != 2
trigger1 = p2statetype = A && p2movetype = H && random < 500
trigger2 = p2dist x > 200 && random < 190
trigger3 = p2dist x > 100 && random < 50
trigger4 = p2dist x > 25 && random < 10

;---------------------------------------------------------------------------
;Fire Bolt
[State -1, AI Fire Bolt]
type = ChangeState
value = 2050
triggerall = var(1) = 1 && power >= 120 && var(19) != 0
triggerall = (p2dist x = [150, 300]) && stateno = 2001
trigger1 = p2movetype = H && random < 500
trigger2 = p2movetype = A && random < 50
trigger3 = p2movetype = I && random < 250

;---------------------------------------------------------------------------
;Cold Bolt
[State -1, AI Cold Bolt]
type = ChangeState
value = 2060
triggerall = var(1) = 1 && stateno = 2001 && random < 300 && p2bodydist x > 150
trigger1 = var(19) = 1 && power >= 190
trigger2 = var(19) = 2 && power >= 150
trigger3 = var(19) = 3 && power >= 280
;trigger4 = var(19) = 0 && power >= 100

;---------------------------------------------------------------------------
;Fire Ball
[State -1, AI Fire Ball]
type = ChangeState
value = 2070
triggerall = var(1) = 1 && stateno = 2001 && power >= 350 && random < 300
trigger1 = var(19) != 1

;---------------------------------------------------------------------------
;Frost Driver
[State -1, AI Frost Driver]
type = ChangeState
value = 2080
triggerall = var(1) = 1 && stateno = 2001 && power >= 100 && random < 200
trigger1 = var(19) = 0
trigger2 = var(19) = 3

;---------------------------------------------------------------------------
;Stone Curse
[State -1, AI Stone Curse]
type = ChangeState
value = 2100
triggerall = var(1) = 1 && stateno = 2001 && power >= 150 && random < 200
triggerall = p2bodydist x < 150
trigger1 = var(19) = 1
trigger2 = var(19) = 3

;===========================================================================
; Special attacks

;Damascus Dagger
[State -1, AI Damascus Dagger]
type = ChangeState
value = 1010
triggerall = var(1) = 1 && (p2bodydist x = [25, 100]) && random < 100 && var(4) < 4
trigger1 = statetype = S && (ctrl)
trigger2 = stateno = 200 && time > 4
trigger3 = (movecontact) && (stateno = [210,230])
trigger4 = (movecontact) && (stateno = [400,430])
trigger5 = stateno = 100 && time < 5
trigger6 = (movecontact) && (stateno = 1020)

;Lightening Kick
[State -1, AI Lightening Kick]
type = ChangeState
value = 1040
triggerall = var(1) = 1 && (p2bodydist x = [100, 400]) && random < 100 && var(4) < 4
trigger1 = statetype = S && (ctrl)
trigger2 = stateno = 200 && time > 4
trigger3 = (movecontact) && (stateno = [210,230])
trigger4 = (movecontact) && (stateno = [400,430])
trigger5 = stateno = 100 && time < 5
trigger6 = (movecontact) && (stateno = 1020)

;---------------------------------------------------------------------------
;Razor Cape
[State -1, AI Razor Cape]
type = ChangeState
value = 1000
triggerall = p2bodydist x < 60 && moveguarded = 0 && var(4) < 4
triggerall = var(1) = 1 && random < 200
trigger1 = statetype != A && (ctrl)
trigger2 = stateno = 200 && time > 4
trigger3 = (movecontact) && (stateno = [210,230])
trigger4 = (movecontact) && (stateno = [400,430])
trigger5 = (movecontact) && (stateno = 1020)

;---------------------------------------------------------------------------
;Napalm Field
[State -1, AI Napalm Field]
type = ChangeState
value = 1020
triggerall = p2bodydist x < 60 && moveguarded = 0 && var(4) < 4
triggerall = var(1) = 1 && random < 200
trigger1 = statetype != A && (ctrl)
trigger2 = stateno = 200 && time > 4
trigger3 = (movecontact) && (stateno = [210,230])
trigger4 = (movecontact) && (stateno = [400,430])
trigger5 = (movecontact) && (stateno = 1020)

;===========================================================================
;---------------------------------------------------------------------------
;Stand Jab
[State -1, AI Stand Jab]
type = ChangeState
value = 200
triggerall = random < 700 && var(1) = 1 && (p2bodydist x < 60) && (p2bodydist y > -120)
trigger1 = statetype = S && (ctrl)
trigger2 = stateno = 200 && time > 4
trigger3 = (movecontact) && (stateno = [210,230])
trigger3 = (movecontact) && (stateno = [400,430])
trigger4 = (movecontact) && (stateno = 1020)

;---------------------------------------------------------------------------
;Stand Punch
[State -1, AI Stand Punch]
type = ChangeState
value = 210
triggerall = random < 700 && var(4) < 4 && var(1) = 1 && (p2bodydist x < 60) && (p2bodydist y > -120)
trigger1 = statetype = S && (ctrl)
trigger2 = (movecontact) && (stateno = [200,230])
trigger3 = (movecontact) && (stateno = [400,430])
trigger4 = (movecontact) && (stateno = 1020)

;---------------------------------------------------------------------------
;Stand Slash
[State -1, AI Stand Slash]
type = ChangeState
value = 220
triggerall = random < 700 && var(1) = 1 && (p2bodydist x < 40) && (p2bodydist y > -60)
trigger1 = statetype = S && (ctrl)
trigger2 = (movecontact) && (stateno = [200,230])
trigger3 = (movecontact) && (stateno = [400,430])
trigger4 = (movecontact) && (stateno = 1020)

;---------------------------------------------------------------------------
;Standing Stab
[State -1, AI Standing Stab]
type = ChangeState
value = 230
triggerall = random < 700 && var(4) < 4 && var(1) = 1 && (p2bodydist x < 60) && (p2bodydist y > -80)
trigger1 = statetype = S && (ctrl)
trigger2 = (movecontact) && (stateno = [200,230])
trigger3 = (movecontact) && (stateno = [400,430])
trigger4 = (movecontact) && (stateno = 1020)

;---------------------------------------------------------------------------
;Taunt
;[State -1, Taunt]
;type = ChangeState
;value = 195
;triggerall = command = "start"
;trigger1 = statetype != A
;trigger1 = ctrl

;---------------------------------------------------------------------------
;Crouching Jab
[State -1, AI Crouching Jab]
type = ChangeState
value = 400
triggerall = random < 700 && var(1) = 1 && (p2bodydist x < 40) && (p2bodydist y > -60)
trigger1 = statetype = C && (ctrl)
trigger2 = (movecontact) && (stateno = [200,230])
trigger3 = (movecontact) && (stateno = [400,430])
trigger4 = (stateno = 400) && (time >= 5)
trigger5 = (movecontact) && (stateno = 1020)

;---------------------------------------------------------------------------
;Crouching Flick Energy
[State -1, AI Crouching Flick Energy]
type = ChangeState
value = 410
triggerall = random < 700 && var(4) < 4 && var(1) = 1 && (p2bodydist x < 60) && (p2bodydist y > -60)
trigger1 = statetype = C && (ctrl)
trigger2 = (movecontact) && (stateno = [200,230])
trigger3 = (movecontact) && (stateno = [400,430])
trigger4 = (movecontact) && (stateno = 1020)

;---------------------------------------------------------------------------
;Crouching Stab
[State -1, AI Crouching Stab]
type = ChangeState
value = 420
triggerall = random < 700 && var(1) = 1 && (p2bodydist x < 40) && (p2bodydist y > -60)
trigger1 = statetype = C && (ctrl)
trigger2 = (movecontact) && (stateno = [200,230])
trigger3 = (movecontact) && (stateno = [400,430])
trigger4 = (movecontact) && (stateno = 1020)

;---------------------------------------------------------------------------
;Crouching Upward Stab
[State -1, AI Crouching Upward Stab]
type = ChangeState
value = 430
triggerall = random < 700 && var(4) < 4 && var(1) = 1 && (p2bodydist x < 60) && (p2bodydist y > -120)
trigger1 = statetype = C && (ctrl)
trigger2 = (movecontact) && (stateno = [200,230])
trigger3 = (movecontact) && (stateno = [400,430])
trigger4 = (movecontact) && (stateno = 1020)

;---------------------------------------------------------------------------
;Jump Jab
[State -1, AI Jump Jab]
type = ChangeState
value = 600
triggerall = random < 700 && var(1) = 1
trigger1 = statetype = A && (ctrl)
trigger2 = stateno = 1350 ;Air blocking
trigger3 = stateno = 100 || stateno = 105 ;Dash/Airdash
trigger4 = (movecontact) && (stateno = 600 || stateno = 620 || stateno = 630)
trigger5 = stateno = 2025 && time > 8

;---------------------------------------------------------------------------
;Lightening Hammer Strike
[State -1, AI Lightening Hammer Strike]
type = ChangeState
value = 610
triggerall = random < 700 && var(4) < 4 && var(1) = 1
trigger1 = statetype = A && (ctrl)
trigger2 = stateno = 1350 ;Air blocking
trigger3 = stateno = 100 || stateno = 105 ;Dash/Airdash
trigger4 = (movecontact) && (stateno = 600 || stateno = 620 || stateno = 630)
trigger5 = stateno = 2025 && time > 8

;---------------------------------------------------------------------------
;Jump Slash
[State -1, AI Jump Slash]
type = ChangeState
value = 620
triggerall = random < 700 && var(1) = 1 && (p2bodydist x < 20) && (p2bodydist y > -90) && (p2bodydist y < 90)
trigger1 = statetype = A && (ctrl)
trigger2 = stateno = 1350 ;Air blocking
trigger3 = stateno = 100 || stateno = 105 ;Dash/Airdash
trigger4 = (movecontact) && (stateno = 600 || stateno = 620 || stateno = 630)
trigger5 = stateno = 2025 && time > 8

;---------------------------------------------------------------------------
;Jump Spinning Dagger
[State -1, AI Spinning Dagger]
type = ChangeState
value = 630
triggerall = random < 700 && var(4) < 4 && var(1) = 1
trigger1 = statetype = A && (ctrl)
trigger2 = stateno = 1350 ;Air blocking
trigger3 = stateno = 100 || stateno = 105 ;Dash/Airdash
trigger4 = (movecontact) && (stateno = 600 || stateno = 620 || stateno = 630)
trigger5 = stateno = 2025 && time > 8

;---------------------------------------------------------------------------
;SP Recovery
[State -1, SP Recovery]
type = ChangeState
value = 300
triggerall = var(1) = 1 && p2movetype = H && power < 5000
trigger1 = (stateno = 0 || stateno = 11) && p2bodydist x > 500
